﻿/**
 * The following is an example implementation of the Javascript object that also contains more documentaion
 * on the different methods. This can/should be used as a starting point for the javascript class.
 */
FileViewer=function()
{

	this.serviceName="";

    /**
     * Constructs a new FileViewer instance.
     * This should probably call into the native side to create the necessary ui elements, but they should be hidden
     * initially.
     */
    this.construct=function()
    {

        if (typeof device == 'undefined')
        { //we are not on phonegap, so make as us at least not complain with a dirty hack...
            window.cordova = {
                exec: function(){}
            };
            return;
        }

		if (device && device.platform=="iOS")
		{
			this.serviceName="com.cn-consult.Xviewer";
            var exec = cordova.require('cordova/exec');
            //exec.setJsToNativeBridgeMode(exec.jsToNativeModes.IFRAME_NAV);
		}
		if (device && device.platform=="Android")
		{
			this.serviceName="xviewer";
		}


    };

	this.onCordovaExecFail=function(_error)
	{
		alert("Cordova exec fail: "+_error);
	};

	this.onCordovaExecSuccess=function()
	{

	};


    /**
     * Sets the rect in which the file-viewer should be displayed.
     * @param {Object} _rect The rectangle to set the dimensions to. This is an object that should contain the following members:
     *             - x: The x coordinate (in screen coordinate-system) where the rect should begin
     *             - y: The y coordinate (in screen coordinate-system) where the rect should begin
     *             - width: The width of the rect
     *             - height: The height of the rect
     */
    this.setRect=function(_rect)
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "setRect", [_rect.x, _rect.y, _rect.width, _rect.height]);
    };

    /**
     * Returns the current rect of the file-viewer to the supplied callback function.
     *
     * @param {Function} _callback The callback function that should be called to deliver the result.
     *                             The callback is called with a single parameter that is an object which contains the information
     *                             about the current rect in the same format as setRect() expects it.
     * @param {Object} _scope The scope in which the callback should be called. (optional)
     */
    this.getRect=function(_callback,_scope)
    {
		cordova.exec(function(rect){
			Ext.callback(_callback,_scope,[rect])
		}, this.onCordovaExecFail, this.serviceName, "getRect", [""]);
    };

    /**
     * Shows the file-viewer on the screen at the previously set coordinates.
     *
     *
     */
    this.show=function()
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "show", [""]);
    };


    /**
     * Hides the file-viewer from the screen.
     * This should not destroy the file-viewer instance.
     */
    this.hide=function()
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "hide", [""]);
    };

    /**
     * Delivers true/false to the supplied callback depending on the visibility of the FileViewer.
     * See show() and hide().
     *
     * @param {Function} _callback The callback function that should be called to deliver the result.
     *                             The callback is called with a single parameter that is a boolean true if the viewer is visible,
     *                             false otherwise.
     *
     * @param {Object} _scope The scope in which the callback should be called. (optional)
     *
     */
    this.isVisible=function(_callback,_scope)
    {
		cordova.exec(function(_visible){
			if (_visible) Ext.callback(_callback,_scope,[true]);
			else Ext.callback(_callback,_scope,[false]);
		}, this.onCordovaExecFail, this.serviceName, "isVisible", [""]);
    };

    /**
     * Tells the viewer to enter the fullscreen-mode.
     * In the fullscreen-mode the viewer occupies the whole screen but it has a toolbar to exit fullscreen mode.
     *
     */
    this.enterFullscreen=function()
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "enterFullscreen", [""]);
    };

    /**
     * Tells the viewer to exit the fullscreen-mode.
     * The viewer should shrink itself down to the previously set rect via setRect().
     *
     */
    this.exitFullscreen=function()
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "exitFullscreen", [""]);
    };

    /**
     * Tells the viewer which file should be displayed.
     * If a file is already displayed the new file should be loaded instead.
     * @param {String} _filePath The path to the file that should be displayed. This can either be a loca file:/// url or a remote http:// url.
     * @param {Object} _options The options with which this file should be displayed. Options may contain the following members:
     *                     - enablePrinting {Bool} If printing the file should be possible or not
     *                     - enableSharing {Bool} If it should be possible to open the file in other software or send it via mail
     */
    this.loadFile=function(_filePath,_options)
    {
		cordova.exec(this.onCordovaExecSuccess, this.onCordovaExecFail, this.serviceName, "loadFile", [_filePath]);
    };



    this.construct(); //call the constructor after having defined all other methods. This should not be removed
};
